
#include <windows.h>
#include <comdef.h>
#include <exdisp.h>
#include <oledlg.h>



// Constants

namespace {
   TCHAR * windowClassName = TEXT("win32host");
   TCHAR * windowTitle     = TEXT("Win32 interface");
   int          windowWidth     = 600;
   int          windowHeight    = 600;
}

    HWND container;

LRESULT CALLBACK WindowProc( HWND hWnd, UINT messg, WPARAM wParam, LPARAM lParam )
{
    switch(messg)
    {
        case WM_SIZE:
        // Redimensionnement du conteneur quand la taille de la fentre change:
        MoveWindow(container,0,0,LOWORD(lParam), HIWORD(lParam),1);
        break;
        case WM_CLOSE:
        // Dtruire la fentre principale:
        DestroyWindow(hWnd);
        break;
        case WM_DESTROY:
        // Envoyer le message de sortie du programme:
        PostQuitMessage( 0 );
        break;
        default:
        //Retour:
        return( DefWindowProc( hWnd, messg, wParam, lParam ) );
    }
    return 0;
}

int CALLBACK WinMain(
   HINSTANCE hInstance,
   HINSTANCE hPrevInstance,
   LPSTR lpCmdLine,
   int nCmdShow)
{

   // Register our Window class
   WNDCLASS wndclass;
   wndclass.style = CS_VREDRAW | CS_HREDRAW;
   wndclass.lpfnWndProc = &WindowProc;
   wndclass.cbClsExtra = 0;
   wndclass.cbWndExtra = 0;
   wndclass.hInstance = hInstance;
   wndclass.hIcon = NULL;
   wndclass.hCursor = NULL;
   wndclass.hbrBackground = reinterpret_cast <HBRUSH> (COLOR_BTNFACE + 1);
   wndclass.lpszMenuName = NULL;
   wndclass.lpszClassName =windowClassName;
   ::RegisterClass(&wndclass);

   // Create our main, raw win32 API window
   // We create the window invisible (meaning that we do not provide WS_VISIBLE as the window style parameter), because making it visible and then
   // adding a HwndSource will make it flicker.
   HWND mainWindow = ::CreateWindow(
      windowClassName,
      windowTitle,
      2,
      CW_USEDEFAULT,
      CW_USEDEFAULT,
      windowWidth,
      windowHeight,
      NULL,
      NULL,
      hInstance,
      0);
   ::ShowWindow (mainWindow, nCmdShow);
   ::UpdateWindow( mainWindow );

    typedef HRESULT (WINAPI *PFonc)(IUnknown*, HWND,IUnknown**);   
    HINSTANCE hDLL2 = ::LoadLibrary(TEXT("atl.dll"));   
    if (!hDLL2) 
      return 1;   

    PFonc AtlAxAttachControl = (PFonc) ::GetProcAddress(hDLL2,"AtlAxAttachControl");

    RECT rect;
    ::GetClientRect(mainWindow,&rect);

    container = ::CreateWindowEx(
        WS_EX_CLIENTEDGE, 
        L"EDIT",
        L"",WS_CHILD | WS_VISIBLE,
        0,
        0,
        rect.right,
        rect.bottom,
        mainWindow,
        0,
        hInstance,
        0);

    HRESULT hr = ::CoInitialize(0);


    IWebBrowser2 *pIwb;
    hr = ::CoCreateInstance(CLSID_WebBrowser,0,CLSCTX_ALL,IID_IWebBrowser2,(void**)&pIwb);
    hr = AtlAxAttachControl(pIwb,container,0);

    if(FAILED(hr))
    {
         MessageBox(0, L"FAILED(AtlAxAttachControl(pitd, container, NULL))", L"Error", MB_ICONERROR | MB_OK);
    }
     pIwb->GoHome();
     pIwb->Navigate2((VARIANT*)L"www.google.com",0,0,0,0);

   // Start message processing
   ::MSG message;
   while (::GetMessageA(&message, 0, 0, 0))
   {
      switch (message.message) {
      case WM_QUIT:
         break;
      default:
         ::TranslateMessage(& message);
         ::DispatchMessage(& message);
         break;
      }
   }

   CoUninitialize();
   FreeLibrary(hDLL2);
   return 0;
}
